/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3ServiceAgentDownloadController=void 0,exports.requestCallDownloadAddons=requestCallDownloadAddons;const xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),fs=require("fs"),JSZip=require("jszip"),path=require("path"),loggers_1=require("../loggers"),logger=loggers_1.loggers.service;class X3ServiceAgentDownloadController{constructor(){this.denied=["node_modules","build"],this.fileListForZip=[],this.zipPackage=new JSZip}generateZipFileLocal(e,t){return this.zipPackage.generateNodeStream({type:"nodebuffer",compression:"DEFLATE",streamFiles:false}).pipe(fs.createWriteStream(path.join(e,`${t}.zip`)))}getZipBuffer(){return this.zipPackage.generateAsync({type:"nodebuffer",compression:"DEFLATE",streamFiles:false})}addZipFile(e){e.forEach(e=>{if(logger.info(`File path: ${e.osPath} - Zip path: ${e.zipPath}`),fs.lstatSync(e.osPath).isDirectory())this.zipPackage.folder(e.zipPath);else this.zipPackage.file(e.zipPath,fs.readFileSync(e.osPath))})}getFolderContent(e,t){if(fs.existsSync(e))if(fs.lstatSync(e).isFile())this.fileListForZip.push({osPath:e,zipPath:t});else fs.readdirSync(e).filter(t=>{if(fs.lstatSync(path.join(e,t)).isDirectory()||fs.lstatSync(path.join(e,t)).isSymbolicLink())return!this.denied.includes(t);return true}).forEach(i=>{this.fileListForZip.push({osPath:path.join(e,i),zipPath:path.join(t,i)}),this.getFolderContent(path.join(e,i),path.join(t,i))})}generateZipFileBuffer(e,t){return this.fileListForZip.push({osPath:e,zipPath:t}),this.getFolderContent(e,t),this.addZipFile(this.fileListForZip),this.getZipBuffer()}createZipFileLocal(e,t,i){return this.fileListForZip.push({osPath:e,zipPath:t}),logger.info(`Folder path: ${e}`),this.getFolderContent(e,t),this.addZipFile(this.fileListForZip),this.generateZipFileLocal(e,i)}}function requestCallDownloadAddons(e,t){const i=t.locals.config??xtrem_x3_config_manager_1.X3ConfigManager.current,r=process.cwd(),o=i.addOns?.folder,s=path.join(r,"add-ons"),n="add-ons",a=o??s,l=new X3ServiceAgentDownloadController;if(!fs.existsSync(a))return logger.error(`The folder ${a} does not exist`),t.status(404).send("The folder add-ons does not exist"),void t.end();l.generateZipFileBuffer(a,n).then(e=>{logger.info("Zip file created successfully"),t.setHeader("Content-Type","application/octet-stream"),t.send(e),t.end()}).catch(e=>{logger.error("Error creating the zip file"),logger.error(e),t.status(500).send("Error creating the zip file"),t.end()})}exports.X3ServiceAgentDownloadController=X3ServiceAgentDownloadController;
//# sourceMappingURL=x3-service-agent-download-controller.js.map