/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3ServiceAgentConfig=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),jwt=require("jsonwebtoken");class X3ServiceAgentConfig{static verifyIsTokenExpire(e,r,t=120){const o=Date.now();if(1e3*e.iat-o>1e3*t)return true;if(e.exp-o>0)throw new Error("Invalid token - expired");if(null!=r&&e.exp-e.iat>r)return true;return false}static async refreshJwtToken(e){const r=Math.floor(Date.now()/1e3),t=await xtrem_x3_config_manager_1.X3ConfigManager.getSecret(),o={iss:e.iss,aud:e.aud,sessionId:e.sessionId,sub:e.sub,iat:r,exp:r+3600};return jwt.sign(o,t)}static async getAuthContext(e){const r=await xtrem_x3_config_manager_1.X3ConfigManager.getSecret(),t=this.extractToken(e);if(!t)throw new Error("No token found in the authorization header");return jwt.verify(t,r||"")}static extractToken(e){if(!e||e.length<8)return null;if(0!==e.indexOf("Bearer "))return null;const r=/^Bearer\s+([a-zA-Z0-9_-]+\.[a-zA-Z0-9_-]+\.[a-zA-Z0-9_-]+)/.exec(e);return r&&r[1]}static async getXtremContextHeader(e,r){if(e.testMode)return Buffer.from(JSON.stringify(r)).toString("base64");return Buffer.from(JSON.stringify(await xtrem_x3_config_manager_1.X3ConfigManager.encrypt(r))).toString("base64")}static processLocalConfig(e){return e.locals.config={...xtrem_core_1.ConfigManager.current,...e.locals.context},e.locals.config}static async processXtremX3Config(e,r){const t=e.header("x-etna-config");if(!r.locals.contextValues)r.locals.contextValues={};const o=xtrem_x3_config_manager_1.X3ConfigManager.current.x3;if(!t){if(r.locals.config=xtrem_core_1.ConfigManager.current,o&&o.development&&o.development.folderName)r.locals.contextValues.folderName=o.development.folderName,r.locals.contextValues.referenceFolder=o.development.referenceFolder||o.development.folderName;return r.locals.contextValues.sessionLogin=r.locals.config.user,r.locals.config}if(Array.isArray(t))r.status(400).json({error:"multiple x-etna-config headers not allowed"});const n=await xtrem_x3_config_manager_1.X3ConfigManager.decrypt(t);if(n.session)n.user=n.session.userName,n.email=n.session.userName,r.locals.contextValues.sessionLogin=n.session.login||n.login,delete n.session;if(n.folderName)r.locals.contextValues.folderName=n.folderName,r.locals.contextValues.referenceFolder=n.referenceFolder||n.folderName;else throw new Error("x-etna-config missing folder name");if(n.sql){if("sqlServer"===n.sql.driver)n.sql.driver="tedious";const e={...o?.sql,...n.sql};n.x3={...o,sql:e},delete n.sql}else n.x3=o;if(!n.x3.sql)throw new Error("X3 SQL config not found");if(n.cookies)r.locals.contextValues.x3Cookies=n.cookies;return r.locals.contextValues.xtremServiceUrl=n.xtremServiceUrl,r.locals.config={...this.processLocalConfig(r),...n},r.locals.config}static async verifyAuthToken(e,r,t){if(e.syracuse){const{token:o}=r,{clockToleranceSeconds:n}=e.syracuse,s=await xtrem_x3_config_manager_1.X3ConfigManager.getClientId(),a=await xtrem_x3_config_manager_1.X3ConfigManager.getSecret();let i;try{i=jwt.verify(o,a||"")}catch(e){throw new Error(`Invalid token - ${e.name} - ${e.message}`)}if(s!==i.iss)throw new Error(`Invalid token - issuer ${s} does not match payload ${i.iss}`);if(this.verifyIsTokenExpire(i,t,n))r.token=await this.refreshJwtToken(i)}else throw Error("Security config incomplete.")}}exports.X3ServiceAgentConfig=X3ServiceAgentConfig;
//# sourceMappingURL=x3-service-agent-config.js.map