import { Context, Dict } from '@sage/xtrem-core';
import { Config } from '@sage/xtrem-shared';
import { X3Config, X3SecurityConfig } from '@sage/xtrem-x3-config-manager';
import { Request, Response } from 'express';
import * as jwt from 'jsonwebtoken';
import { X3HeaderContext } from '../api';
interface XtremContextHeader {
    service?: string;
    session?: string;
    params: Dict<string>;
}
export declare class X3ServiceAgentConfig {
    private static verifyIsTokenExpire;
    static refreshJwtToken(payload: any): Promise<string>;
    /**
     *
     * @param auth
     */
    static getAuthContext(auth: string): Promise<jwt.JwtPayload | string>;
    /**
     * Extract the token from the authorization header
     * @param authHeader
     * @returns
     */
    static extractToken(authHeader: string): string | null;
    /**
     * Get the encrypted base64 value for the header 'x-xtrem-context'
     */
    static getXtremContextHeader(context: Context, xtremContextHeader: XtremContextHeader): Promise<string>;
    static processLocalConfig(res: Response): Config;
    static processXtremX3Config(req: Request, res: Response): Promise<X3Config>;
    static verifyAuthToken(security: X3SecurityConfig, context: X3HeaderContext, expiration?: number): Promise<void>;
}
export {};
//# sourceMappingURL=x3-service-agent-config.d.ts.map