/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TRACE_DATA=exports.X3ServiceAgentGenerationTraceSteps=exports.TraceStatus=void 0,exports.addEventToTrace=addEventToTrace,exports.requestCallExternalGeneration=requestCallExternalGeneration;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),xtrem_x3_dictionary_1=require("@sage/xtrem-x3-dictionary"),auth_1=require("../auth"),x3_service_agent_generate_controller_1=require("../controller/x3-service-agent-generate-controller"),loggers_1=require("../loggers"),logger=loggers_1.loggers.service;var TraceStatus,X3ServiceAgentGenerationTraceSteps;!function(e){e.START="START",e.COMPLETED="COMPLETED",e.IN_PROGRESS="IN_PROGRESS",e.ERROR="ERROR"}(TraceStatus||(exports.TraceStatus=TraceStatus={})),function(e){e.MAIN_PROCESS="MAIN PROCESS GENERATION",e.PACKAGE_GENERATION="PACKAGE GENERATION",e.TRANSLATION_GENERATION="TRANSLATION GENERATION",e.COPY_TO_TEMP_DIRECTORY="COPY TO TEMP_DIRECTORY",e.UNZIP_PACKAGE="UNZIP PACKAGE",e.BUILD_PACKAGE="BUILD PACKAGE",e.KILL_PROCESS="KILL PROCESS"}(X3ServiceAgentGenerationTraceSteps||(exports.X3ServiceAgentGenerationTraceSteps=X3ServiceAgentGenerationTraceSteps={})),exports.TRACE_DATA={};const requestFunnel={};function addEventToTrace(e,t,r,n){exports.TRACE_DATA[e].events.push(t),exports.TRACE_DATA[e].end_time=r??"",exports.TRACE_DATA[e].global_status=n??exports.TRACE_DATA[e].global_status}async function requestCallExternalGeneration(e,t){logger.info("Gathering configuration and session context"),await auth_1.X3ServiceAgentConfig.processXtremX3Config(e,t);const r=xtrem_core_1.Uuid.generate().toHexString(),n=t.locals.config??xtrem_x3_config_manager_1.X3ConfigManager.current,o=t.locals.contextValues??{},a=e.get("x3-folder-name")??o.folderName??n.x3?.development?.folderName,s="x3";if(!a)return logger.error("Folder name not found in request or context"),void t.status(400).json({message:"Folder name not found in request or context"});if(!n.x3?.sql)return logger.error("X3 SQL configuration not found."),void t.status(400).json({message:"X3 SQL configuration not found."});const i=xtrem_x3_dictionary_1.X3DictionaryHelper.getConnectionPool(n.x3.sql);if(0===Object.keys(o).length)return logger.error("No config context values found in request"),void t.status(400).json({message:"No config context values found in request"});logger.info(`Requesting external generation for ${a} with service ${s}`);let c=e.body;if(Buffer.isBuffer(e.body))logger.info("ZIP file received from request");else c=void 0,logger.info("No ZIP file received from request");const g=(await xtrem_x3_dictionary_1.X3PackageGenerator.getPackages(i,a,s,{specificOnly:true})).filter(e=>"@sage"!==(e.name.split("/").shift()??""));if(logger.info(`Found ${g.length} packages to generate`),0===g.length)return void t.status(400).json({message:"No packages found."});if(exports.TRACE_DATA[r]={context:{service_name:s,folder_name:a,trace_id:r,session:o.session},global_status:TraceStatus.START,attributes:{},start_time:(new Date).toISOString(),end_time:"",events:[]},!requestFunnel[a])requestFunnel[a]=(0,xtrem_core_1.funnel)(1);requestFunnel[a](()=>x3_service_agent_generate_controller_1.X3ServiceAgentGenerateController.externalGeneration(n,a,s,i,g,c,r,o)),t.status(200).json({message:"Deployment started",traceId:r})}
//# sourceMappingURL=x3-service-agent-request-generation.js.map