import { Request, Response } from 'express';
export interface X3HeaderContext {
    apiUrl: string;
    cookies: string;
    folderName: string;
    host: string;
    origin: string;
    referenceFolder: string;
    session: string;
    sessionLogin: string;
    soapUrl: string;
    token: string;
    tokenLogin: string;
    xtremServiceUrl: string;
}
interface Traces {
    [traceId: string]: Trace;
}
export declare enum TraceStatus {
    START = "START",
    COMPLETED = "COMPLETED",
    IN_PROGRESS = "IN_PROGRESS",
    ERROR = "ERROR"
}
export declare enum X3ServiceAgentGenerationTraceSteps {
    MAIN_PROCESS = "MAIN PROCESS GENERATION",
    PACKAGE_GENERATION = "PACKAGE GENERATION",
    TRANSLATION_GENERATION = "TRANSLATION GENERATION",
    COPY_TO_TEMP_DIRECTORY = "COPY TO TEMP_DIRECTORY",
    UNZIP_PACKAGE = "UNZIP PACKAGE",
    BUILD_PACKAGE = "BUILD PACKAGE",
    KILL_PROCESS = "KILL PROCESS"
}
interface TraceEvent {
    name: string;
    timestamp: string;
    status: TraceStatus;
    parent_trace_id: string;
    event_attributes?: Record<string, string>;
    message?: string;
}
export interface Trace {
    context: {
        service_name: string;
        folder_name: string;
        trace_id: string;
        session: string;
    };
    start_time: string;
    end_time?: string;
    attributes?: Record<string, string>;
    global_status?: TraceStatus;
    events: Array<TraceEvent>;
}
export declare const TRACE_DATA: Traces;
export declare function addEventToTrace(trace_id: string, event: TraceEvent, end_time?: string, global_status?: TraceStatus): void;
export declare function requestCallExternalGeneration(req: Request, res: Response): Promise<void>;
export {};
//# sourceMappingURL=x3-service-agent-request-generation.d.ts.map