/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3ApiTracerHelper=void 0;const xtrem_core_1=require("@sage/xtrem-core"),axios_1=require("axios"),auth_1=require("../auth");class X3ApiTracerHelper{static getConfig(e){const r=xtrem_core_1.ConfigManager.current,{token:i,apiUrl:t,session:o,cookie:s,origin:n}=e,a=1e3*(r.graphql?.timeLimitInSeconds??60);if(t||i){let e;if(!i)throw e="Token is mandatory",new Error(e);if(!t)throw e="URL is mandatory",new Error(e);return{apiUrl:t,token:i,session:o,requestTimeout:a,cookie:s,origin:n}}const c=r.x3;if("development"===r.deploymentMode&&c.development&&c.development.api){const e=c.development.api;if(!c.development.folderName)throw new Error("Folder name missing from the web service config");if(!e.url)throw new Error("URL is missing from web service config");if(!e.userCredentials||!e.userCredentials.userName||!e.userCredentials.password)throw new Error("User credential is missing from web service config");return{apiUrl:e.url,userCredentials:e.userCredentials,requestTimeout:a,origin:e.origin??n}}throw new Error("Failed to load API config")}static async sendRequest(e,r,i){const t=this.getConfig(i),{apiUrl:o,token:s,userCredentials:n,session:a,cookie:c,origin:l}=t;let u="";if(s)u=`Bearer ${s}`;else{u=`Basic ${Buffer.from(`${n?.userName||""}:${n?.password}`).toString("base64")}`}const m={session:a,service:r,params:{origin:l}},p={"Content-Type":"text/plain",Authorization:u,Connection:"Keep-Alive","accept-language":"base"===i.currentLocale?"en-US":i.currentLocale,"x-xtrem-context":await auth_1.X3ServiceAgentConfig.getXtremContextHeader(i,m)};if(c)p.Cookie=c;const d={method:"post",baseURL:new URL(o).origin,url:"/xtrem/trace/",headers:p,data:e,timeout:i.requestTimeout??6e4};return await(0,axios_1.default)(d)}}exports.X3ApiTracerHelper=X3ApiTracerHelper;
//# sourceMappingURL=x3-service-agent-api-trace-helper.js.map