import { AxiosResponse } from 'axios';
import { Trace } from './x3-service-agent-request-generation';
export interface ApiConfigContext {
    apiUrl: string;
    token: string;
    session: string;
    cookie: string;
    origin: string;
}
export declare class X3ApiTracerHelper {
    /**
     * Get the API configuration from the xtrem config and context values passed from Syracuse
     * @param context
     * @returns
     */
    private static getConfig;
    /**
     * Send request to X3 xtrem API
     * @param context
     * @param type
     * @param nodeName
     * @param operationName
     * @param requestData
     * @param service
     * @returns
     */
    static sendRequest(requestTraceData: Trace, service: string, context: any): Promise<AxiosResponse>;
}
//# sourceMappingURL=x3-service-agent-api-trace-helper.d.ts.map