type InputType = string | URL | Request;
type FetchFunction = (input: InputType, init?: RequestInit) => Promise<Response>;
type HandlerFunction = (request: Request) => Promise<Response> | Response;
type MiniFetchMockMethod = "get" | "put" | "post" | "patch" | "delete" | "any";
type MiniFetchMockHandler = {
    matchMethod: MiniFetchMockMethod;
    urlRegex: RegExp;
    handler: HandlerFunction;
    delayMs: number | undefined;
    repeat: number | undefined;
    callCount: number;
};
export interface MiniFetchMock {
    realFetch: FetchFunction | undefined;
    handlers: MiniFetchMockHandler[];
    fetchHandler: FetchFunction;
    mock: (method: MiniFetchMockMethod, urlRegex: RegExp, handler: HandlerFunction, delayMs?: number, repeat?: number) => MiniFetchMock;
    enable: () => void;
    disable: () => void;
    mockGet: (urlRegex: RegExp, handler: HandlerFunction, delayMs?: number, repeat?: number) => MiniFetchMock;
    mockPost: (urlRegex: RegExp, handler: HandlerFunction, delayMs?: number, repeat?: number) => MiniFetchMock;
    mockPatch: (urlRegex: RegExp, handler: HandlerFunction, delayMs?: number, repeat?: number) => MiniFetchMock;
    mockDelete: (urlRegex: RegExp, handler: HandlerFunction, delayMs?: number, repeat?: number) => MiniFetchMock;
    mockAny: (urlRegex: RegExp, handler: HandlerFunction, delayMs?: number, repeat?: number) => MiniFetchMock;
}
export declare const buildMockResponse: (request: Request, status: number, data: object | undefined, headers?: Record<string, string>, statusText?: string) => Response;
export declare const getMockRequestBody: <T>(request: Request) => Promise<T>;
export declare const getMockRequestParams: <T>(request: Request) => T;
declare const miniFetchMock: MiniFetchMock;
export default miniFetchMock;
