type EventSourceEventType = "open" | "message" | "error";
interface MockEventSourceEvent {
    type: EventSourceEventType;
    data?: string;
    id?: string;
    retry?: number;
    delay?: number;
}
interface MockEventSourceConfig {
    url: string;
    events: () => MockEventSourceEvent[];
    autoClose?: boolean;
}
type EventSourceMockHandler = {
    urlRegex: RegExp;
    config: MockEventSourceConfig;
    repeat?: number;
    callCount: number;
};
export interface EventSourceMock {
    realEventSource: typeof EventSource | undefined;
    handlers: EventSourceMockHandler[];
    eventSourceHandler: typeof EventSource;
    mock: (urlRegex: RegExp, config: MockEventSourceConfig, repeat?: number) => EventSourceMock;
    enable: () => void;
    disable: () => void;
}
declare const eventSourceMock: EventSourceMock;
export declare const createSSEEvent: (type: "open" | "message" | "error", data?: any, options?: {
    delay?: number;
    id?: string;
    retry?: number;
}) => MockEventSourceEvent;
export default eventSourceMock;
