import { BarChartData, BarChartOptions, LineChartData, LineChartOptions, PieChartData, PieChartOptions } from "@sageai/chartist";
import { UUIDType } from "./SessionMessage";
import { SageIconType } from "./SageIconType";
import { LinkIconColor } from "./LinkIconColors";
import { CssColor } from "./CssColor";
export type MessagePartTableKind = "generic_table";
export type MessagePartTableRowKind = "generic_row";
export type MessagePartHyperLinkType = "internal" | "external";
export type MessagePartHyperLinkStyle = "button" | "link_standard" | "link_subtle" | "link_negative";
export type MessagePartHyperLinkTarget = "blank" | "self" | "popup";
export type MessagePartDisplayArea = "chat" | "analysis" | "explanation";
export type TableCellAlignment = "left" | "center" | "right";
export type TableCellTextWrapping = "nowrap" | "wrap" | "wrap_to_ellipsis" | "ellipsis";
export type TableIconKind = "none" | "warning" | "tick" | "caret_down" | "caret_up" | SageIconType;
export type TableIconPosition = "left" | "right";
export type TableCellWidth = `${number}%`;
export type TableCellStyle = "standard" | "negative" | "positive" | "neutral" | "warning" | "information" | CssColor;
export type GenericLegacyTableCellKind = "text" | "currency" | "date" | "link" | "pill";
export type GenericTableCellKind = GenericLegacyTableCellKind | "html";
export type DetailSeparatorBehavior = "expand" | "switch";
export interface IMessagePartBase {
    message_part_id: UUIDType;
    message_id: UUIDType;
    part_index: number;
    kind: string;
    created_at: Date;
    display_area: MessagePartDisplayArea;
}
export interface IMessagePartText extends IMessagePartBase {
    kind: "text";
    text: string;
    lhs_icon: SageIconType | undefined;
    lhs_icon_color: LinkIconColor | undefined;
}
export interface IMessagePartIFrame extends IMessagePartBase {
    kind: "iframe";
    text: string;
}
export interface IMessagePartExplanation extends IMessagePartBase {
    kind: "explanation";
    text: string;
}
export interface IMessagePartTitle extends IMessagePartBase {
    kind: "title";
    text: string;
}
export interface IMessagePartSummary extends IMessagePartBase {
    kind: "summary";
    text: string;
}
export interface IHyperLinkOptions {
    target: MessagePartHyperLinkTarget;
}
export interface IMessagePartHyperlink extends IMessagePartBase {
    kind: "hyperlink";
    text: string;
    url: string;
    link_type: MessagePartHyperLinkType;
    link_style: MessagePartHyperLinkStyle;
    show_icon: boolean;
    icon: SageIconType | undefined;
    icon_color: LinkIconColor | undefined;
    link_options: IHyperLinkOptions | undefined;
    dataRolePostfix: string;
}
export interface IMessagePartDetailSeparator extends IMessagePartBase {
    kind: "detail_separator";
    text: string;
    link_style: MessagePartHyperLinkStyle;
    show_icon: boolean;
    behavior: DetailSeparatorBehavior;
}
export interface IMessagePartIntacctCloseHeading extends IMessagePartBase {
    kind: "intacct_close_heading";
    text: string;
    update_ts: Date;
}
export interface IStyledPrompt {
    prompt: string;
    alt_display_text: string | undefined;
    style: MessagePartHyperLinkStyle;
    icon: SageIconType | undefined;
    icon_color: LinkIconColor | undefined;
    canonical_question_id: string | undefined;
    dataRolePostfix: string;
}
export interface IMessagePartPrompt extends IMessagePartBase {
    kind: "prompt";
    prompts: IStyledPrompt[];
}
export interface IMessagePartSubmit extends IMessagePartBase {
    kind: "submit";
    prompt_text: IStyledPrompt;
}
export interface IMessagePartSubmitBase extends IMessagePartBase {
    key: string;
    label?: string;
    required?: boolean;
}
export interface IMessagePartSubmitSelect extends IMessagePartSubmitBase {
    kind: "submit_select";
    options: IMessagePartSelectOption[];
    placeholder: string;
}
export interface IMessagePartSubmitText extends IMessagePartSubmitBase {
    kind: "submit_text";
}
export interface IMessagePartSelectOption {
    label: string;
    value: string;
}
export interface IMessagePartPollInsights extends IMessagePartBase {
    kind: "poll_insights";
    stop_condition: "new_insight";
    initial_wait_seconds: number;
    wait_seconds: number;
    timeout_seconds: number;
}
export interface IMessagePartChart extends IMessagePartBase {
    kind: "chart";
    chart_data: IMessagePartChartData;
}
export interface IMessagePartChartLabelInterpolationFnc {
    func: string;
    args: any[];
}
export type ChartXLabelWrapping = Omit<TableCellTextWrapping, "wrap_to_ellipsis" | "ellipsis">;
export interface IMessagePartChartCopilotOptions {
    labelInterpolationFncX?: IMessagePartChartLabelInterpolationFnc[];
    labelInterpolationFncY?: IMessagePartChartLabelInterpolationFnc[];
    widenLabelsY?: boolean;
    wrapLabelsY?: TableCellTextWrapping;
    wrapLabelsX?: ChartXLabelWrapping;
}
export interface IMessagePartBarChartData {
    kind: "bar";
    data: BarChartData;
    options?: BarChartOptions;
    copilot_options?: IMessagePartChartCopilotOptions;
}
export interface IMessagePartLineChartData {
    kind: "line";
    data: LineChartData;
    options?: LineChartOptions;
    copilot_options?: IMessagePartChartCopilotOptions;
}
export interface IMessagePartPieChartData {
    kind: "pie";
    data: PieChartData;
    options?: PieChartOptions;
    copilot_options?: IMessagePartChartCopilotOptions;
}
export type IMessagePartChartData = IMessagePartBarChartData | IMessagePartLineChartData | IMessagePartPieChartData;
export interface IMessagePartTable extends IMessagePartBase {
    kind: "table";
    table_data: ITableData;
}
export interface ITableData {
    kind: "generic_table";
    headings: (IGenericTableCell | IGenericHtmlTableCell)[];
    rows: IGenericTableRow[];
}
interface ITableRowBase {
    kind: MessagePartTableRowKind;
    row_id: string;
}
export interface IGenericHtmlTableCell {
    kind: "html";
    cell_id: UUIDType;
    content_html: string;
    width: TableCellWidth;
    align: TableCellAlignment;
}
export interface IGenericLegacyTableCell {
    kind: GenericLegacyTableCellKind;
    cell_id: UUIDType;
    value: string | Date | ITableLink;
    align: TableCellAlignment;
    wrap: TableCellTextWrapping;
    icon: ITableIcon;
    style: TableCellStyle;
}
export interface IGenericTableCell extends IGenericLegacyTableCell {
    sub_cell?: IGenericLegacyTableCell;
    width: TableCellWidth;
}
export interface IGenericTableRow extends ITableRowBase {
    kind: "generic_row";
    cells: (IGenericTableCell | IGenericHtmlTableCell)[];
}
export interface ITableLink {
    kind: "table_link";
    text: string;
    url: string;
    link_type: MessagePartHyperLinkType;
    link_style: MessagePartHyperLinkStyle;
    show_icon: boolean;
    link_options: IHyperLinkOptions | undefined;
    dataRolePostfix: string;
}
export interface ITableIcon {
    kind: TableIconKind;
    position: TableIconPosition;
    color: TableCellStyle | undefined;
}
export {};
