import { InsightPatch } from "./Insights";
import { MessagePatch } from "./MessagePatch";
import { IMessagePartBase } from "./SessionMessageParts";
import { SpeakerType } from "./SpeakerType";
export type TagType = "inflight" | "chat" | "history" | "insight";
export type InsightMessageReadStatus = "read" | "unread" | undefined;
export type UUIDType = ReturnType<typeof Crypto.prototype.randomUUID>;
export type MessageIdType = UUIDType;
export declare const messageHasFeedback: (msg: MessagePatch) => boolean;
export declare const patchSessionMessages: (messages: SessionMessage[], messageId: MessageIdType, messagePatch: MessagePatch) => SessionMessage[];
export declare const patchInsightSessionMessages: (insights: InsightSessionMessage[], insightId: MessageIdType, insightPatch: InsightPatch) => {
    insights: InsightSessionMessage[];
    unreadDelta: number;
};
export type MessageFeedback = "negative" | "positive" | "unknown";
export interface SessionMessage {
    message_id: MessageIdType;
    session_id?: UUIDType;
    speaker: SpeakerType;
    created_at: Date;
    message?: string;
    message_parts: IMessagePartBase[];
    tag: TagType;
    hasFeedback: boolean;
    regeneratable: boolean;
    response_stream_key?: string;
    trace_id?: UUIDType;
}
export interface InsightSessionMessage extends SessionMessage {
    session_name?: string;
    session_id: UUIDType;
    status: InsightMessageReadStatus;
}
