import { UUIDType } from "./SessionMessage";
export type SessionIdType = UUIDType | "";
export interface SessionPatch {
    session_name?: string;
    favorited?: boolean;
}
export type SessionViewState = "view" | "delete" | "edit";
export interface Session {
    session_id: SessionIdType;
    session_name: string;
    created_at: Date;
    favorited: boolean;
    viewState: SessionViewState;
    busy: boolean;
    active: boolean;
}
export declare const getDefaultSessionName: () => string;
