import { UUIDType } from "./SessionMessage";
import { IMessagePartBase } from "./SessionMessageParts";
export interface TenantProxiedQueryResult {
    status_code: number;
    headers?: {
        [key: string]: string;
    };
    body?: object;
}
export interface ProxiedQueryResult extends TenantProxiedQueryResult {
    part_index: number;
    response_part_id: UUIDType;
    state?: object;
}
export interface TenantProxiedQueryDefinition {
    method: "POST" | "GET";
    url: string;
    headers?: {
        [key: string]: string;
    };
    params?: {
        [key: string]: string;
    };
    body?: object;
    timeout_seconds?: number;
}
export interface IMessagePartProxiedQueryDefinition extends IMessagePartBase, TenantProxiedQueryDefinition {
    kind: "proxied_query_definition";
    state?: object;
}
