import { MessageIdType, SessionMessage, UUIDType } from "./SessionMessage";
import { ProxiedQueryResult } from "./ProxiedQuery";
export type MaybeCorrelationId = {
    correlation_id?: UUIDType;
};
export type ChatRequest = MaybeCorrelationId & {
    session_id?: string;
    message: string;
    context?: Record<string, any>;
    model?: string;
    insight_id?: MessageIdType;
    ref_message_id?: MessageIdType;
    ref_message_part_id?: MessageIdType;
    canonical_question_id?: string;
};
export type ChatResponse = {
    sessionId: UUIDType;
    sessionName: string | undefined;
    messages: SessionMessage[];
    requestId: UUIDType | undefined;
    correlationId: UUIDType | undefined;
};
export type ProxiedQueryResultRequest = MaybeCorrelationId & {
    session_id?: string;
    kind: "proxied_query_result_request";
    context: Record<string, any>;
    response_message_id: UUIDType;
    response_data: ProxiedQueryResult[];
};
