import { RenderOptions, RenderResult } from "@testing-library/react";
import { ReactElement } from "react";
import { DefaultTheme } from "styled-components";
import { BackendSettings } from "../contexts/BackendContext";
import { BackendInterface } from "../contexts/backend/BackendInterface";
import { UiSettings } from "../contexts/client/UiSettingsContext";
export interface ICopilotRenderWrapperOptions {
    userLocale?: string;
    theme?: DefaultTheme;
    backendSettings?: BackendSettings;
    backendInterface?: BackendInterface;
    uiSettings?: UiSettings;
}
export interface ICopilotRenderOptions extends Omit<RenderOptions, "wrapper">, ICopilotRenderWrapperOptions {
}
declare const copilotRender: (ui: ReactElement, options?: ICopilotRenderOptions) => RenderResult;
export default copilotRender;
