import { Session, SessionIdType, SessionViewState } from "../../types/Session";
import { BackendSettings } from "../../contexts/BackendContext";
import { UiSettings } from "../../contexts/client/UiSettingsContext";
import { BackendInterface } from "../../contexts/backend/BackendInterface";
import { StarterSessionMessage } from "../../types/StarterSessionMessage";
import { StoreFetchResult, StoreFetchStatus } from "../../types/StoreFetchStatus";
import { StoreCommonState } from "../../types/StoreCommonState";
import { RequestReason } from "../../types/RequestReason";
export type SessionsState = {
    selectedSessionId: SessionIdType;
    sessionsFetchStatus: StoreFetchStatus;
    sessionsFetchResult: StoreFetchResult;
    sessions: Session[];
    _starterFetchStatus: StoreFetchStatus;
    starterFetchResult: StoreFetchResult;
    starter?: StarterSessionMessage;
};
export type SessionsActions = {
    loadSessions: (reason: RequestReason) => Promise<void>;
    loadStarter: (reason: RequestReason) => Promise<void>;
    addStarterToSessions: () => void;
    _setSelectedSessionId: (newSessionId: SessionIdType) => void;
    addToSessions: (session_id: SessionIdType, session_name?: string) => void;
    setSessionState: (sessionId: SessionIdType, sessionState: Partial<Session>) => void;
    setSessionFavorite: (sessionId: SessionIdType, favorited: boolean) => Promise<void>;
    setSessionName: (sessionId: SessionIdType, name: string) => Promise<void>;
    deleteSession: (sessionId: SessionIdType) => Promise<void>;
    setSessionView: (sessionId: SessionIdType, view: SessionViewState) => void;
    setSelectedSessionId: (sessionId: SessionIdType) => void;
    getSelectedChatSession: () => Session | undefined;
    setNewSessionIdAndName: (sessionId: SessionIdType, sessionName: string) => void;
    handleNewChatMessages: (messagesSessionId: SessionIdType, messagesSessionName: string | undefined) => void;
    reset: () => void;
};
type SessionsStoreType = StoreCommonState & SessionsState & SessionsActions;
export interface SessionStoreProps {
    uiSettings: UiSettings;
    backendSettings: BackendSettings;
    backendInterface: BackendInterface;
}
export type SessionStore = ReturnType<typeof createSessionsStore>;
export declare const createSessionsStore: (initProps: SessionStoreProps) => Omit<Omit<Omit<Omit<import("zustand").StoreApi<SessionsStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: SessionsStoreType | Partial<SessionsStoreType> | ((state: SessionsStoreType) => SessionsStoreType | Partial<SessionsStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<SessionsStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: SessionsStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: SessionsStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<SessionsStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: SessionsStoreType | Partial<SessionsStoreType> | ((state: import("immer").WritableDraft<SessionsStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: SessionsStoreType, previousSelectedState: SessionsStoreType) => void): () => void;
        <U>(selector: (state: SessionsStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
};
export declare const SessionsContext: import("react").Context<(Omit<Omit<Omit<Omit<import("zustand").StoreApi<SessionsStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: SessionsStoreType | Partial<SessionsStoreType> | ((state: SessionsStoreType) => SessionsStoreType | Partial<SessionsStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<SessionsStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: SessionsStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: SessionsStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<SessionsStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: SessionsStoreType | Partial<SessionsStoreType> | ((state: import("immer").WritableDraft<SessionsStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: SessionsStoreType, previousSelectedState: SessionsStoreType) => void): () => void;
        <U>(selector: (state: SessionsStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
}) | null>;
export declare function useSessionsStore<T>(selector: (state: SessionsState & SessionsActions) => T): T;
export declare const useSessionsStoreHelpers: () => {
    subscribe: {
        (listener: (selectedState: SessionsStoreType, previousSelectedState: SessionsStoreType) => void): () => void;
        <U>(selector: (state: SessionsStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
    getState: () => SessionsStoreType;
    setState: (nextStateOrUpdater: SessionsStoreType | Partial<SessionsStoreType> | ((state: import("immer").WritableDraft<SessionsStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined) => void;
};
type UseSessionsStoreHelpersReturnType = ReturnType<typeof useSessionsStoreHelpers>;
export type SessionsStoreGetState = UseSessionsStoreHelpersReturnType["getState"];
export {};
