import { StoreFetchResult, StoreFetchStatus } from "../../types/StoreFetchStatus";
import { StoreCommonState } from "../../types/StoreCommonState";
import { RequestReason } from "../../types/RequestReason";
import { UiSettings } from "../../contexts/client/UiSettingsContext";
import { BackendSettings } from "../../contexts/BackendContext";
import { BackendInterface } from "../../contexts/backend/BackendInterface";
import { ServerConfig } from "../../types/ServerConfig";
export type ServerConfigState = {
    serverConfigFetchResult: StoreFetchResult;
    serverConfigFetchStatus: StoreFetchStatus;
    serverConfig: ServerConfig;
    selectedModel: string | undefined;
};
export type ServerConfigActions = {
    loadServerConfig: (reason: RequestReason) => Promise<void>;
    _canLoadServerConfig: () => boolean;
    reset: () => void;
    setSelectedModel: (model: string | undefined) => void;
};
type ServerConfigStoreType = StoreCommonState & ServerConfigState & ServerConfigActions;
export interface ServerConfigStoreProps {
    uiSettings: UiSettings;
    backendSettings: BackendSettings;
    backendInterface: BackendInterface;
}
export type ServerConfigStore = ReturnType<typeof createServerConfigStore>;
export declare const createServerConfigStore: (initProps: ServerConfigStoreProps) => Omit<Omit<Omit<Omit<import("zustand").StoreApi<ServerConfigStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: ServerConfigStoreType | Partial<ServerConfigStoreType> | ((state: ServerConfigStoreType) => ServerConfigStoreType | Partial<ServerConfigStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<ServerConfigStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: ServerConfigStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: ServerConfigStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<ServerConfigStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: ServerConfigStoreType | Partial<ServerConfigStoreType> | ((state: import("immer").WritableDraft<ServerConfigStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: ServerConfigStoreType, previousSelectedState: ServerConfigStoreType) => void): () => void;
        <U>(selector: (state: ServerConfigStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
};
export declare const ServerConfigContext: import("react").Context<(Omit<Omit<Omit<Omit<import("zustand").StoreApi<ServerConfigStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: ServerConfigStoreType | Partial<ServerConfigStoreType> | ((state: ServerConfigStoreType) => ServerConfigStoreType | Partial<ServerConfigStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<ServerConfigStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: ServerConfigStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: ServerConfigStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<ServerConfigStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: ServerConfigStoreType | Partial<ServerConfigStoreType> | ((state: import("immer").WritableDraft<ServerConfigStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: ServerConfigStoreType, previousSelectedState: ServerConfigStoreType) => void): () => void;
        <U>(selector: (state: ServerConfigStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
}) | null>;
export declare function useServerConfigStore<T>(selector: (state: ServerConfigState & ServerConfigActions) => T): T;
export declare const useServerConfigStoreWithoutSelector: () => ServerConfigStoreType;
export declare const useServerConfigStoreHelpers: () => {
    subscribe: {
        (listener: (selectedState: ServerConfigStoreType, previousSelectedState: ServerConfigStoreType) => void): () => void;
        <U>(selector: (state: ServerConfigStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
    getState: () => ServerConfigStoreType;
    setState: (nextStateOrUpdater: ServerConfigStoreType | Partial<ServerConfigStoreType> | ((state: import("immer").WritableDraft<ServerConfigStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined) => void;
};
export {};
