import { InsightSessionMessage, MessageIdType, SessionMessage, UUIDType } from "../../types/SessionMessage";
import { MessagePatch } from "../../types/MessagePatch";
import { BackendSettings } from "../../contexts/BackendContext";
import { SessionIdType } from "../../types/Session";
import { ChatResponse, ProxiedQueryResultRequest } from "../../types/ChatRequest";
import { BackendInterface } from "../../contexts/backend/BackendInterface";
import { SessionsStoreGetState } from "../sessions/SessionsStore";
import { UiSettings } from "../../contexts/client/UiSettingsContext";
import { SuggestedPrompt } from "../../types/SuggestedPrompt";
import { StoreFetchResult, StoreFetchStatus } from "../../types/StoreFetchStatus";
import type { StoreCommonState } from "../../types/StoreCommonState";
import { RequestReason } from "../../types/RequestReason";
import { MessageSubmitState } from "../../types/MessageSubmitState";
import { ChatContext } from "../../types/ChatContext";
import { IMessagePartProxiedQueryDefinition } from "../../types/ProxiedQuery";
export declare const CHAT_ENTRY_TEXT_MAX_LENGTH = 1000;
export type OnNewChatMessages = (messages: SessionMessage[]) => void;
/**
 * Controls message history fetching after a chat response:
 * - none: Nothing has happened yet
 * - session-unchanged: The selectedSessionId has not changed while waiting for the chat response
 *     (or if it has, it's now back to the chat in flight). In this situation, there is no special handling required
 * - new-session: The selectedSessionId is changing from "" to the new sessionId from the backend.
 *     In this situation, we keep the chat response, and don't bother to fetch the message history
 *     (because there won't be any).
 * - session-changed: The selectedSessionId has changed while waiting for the chat response.
 *     In this situation, we keep the chat response, and fetch the message history.
 */
export type NewResponseState = "none" | "session-unchanged" | "new-session" | "session-changed";
type Session = {
    inFlightMessages: SessionMessage[];
    chatMessages: SessionMessage[];
    messageHistoryLastSeen: Date | null;
    messageHistoryMoreAvailable: boolean;
    insightInitiated: boolean;
};
type Sessions = {
    [sessionId: string]: Session;
};
export type ChatMessagesState = {
    _syncedSessionId: SessionIdType;
    inFlightSessionId: SessionIdType | null;
    chatFetchStatus: StoreFetchStatus;
    chatFetchResult: StoreFetchResult;
    _sessions: Sessions;
    messageHistoryFetchStatus: StoreFetchStatus;
    messageHistoryFetchResult: StoreFetchResult;
    messageHistoryHTTPStatus: number | undefined;
    messageHistoryBackgroundFetch: boolean;
    _newResponseState: NewResponseState;
    suggestedPrompts: SuggestedPrompt[];
    suggestedPromptsFetchStatus: StoreFetchStatus;
    suggestedPromptsFetchResult: StoreFetchResult;
    chatEntryText: string;
    messageSubmitStates: Record<MessageIdType, MessageSubmitState>;
};
export type ChatMessagesActions = {
    _addChatMessages: (sessionId: SessionIdType, messages: SessionMessage[]) => void;
    _emptyChatMessages: (sessionId: string) => void;
    _patchChatMessages: (messageId: MessageIdType, messagePatch: MessagePatch) => void;
    _addMessageInFlight: (humanMessage: string, sessionId: SessionIdType) => void;
    _addResponseAndRemoveInFlight: (sessionId: SessionIdType, result: StoreFetchResult, responseState: NewResponseState, newChatMessages: SessionMessage[]) => void;
    handleSSEMessages: (sessionStoreGetState: SessionsStoreGetState, onNewChatMessages: OnNewChatMessages | null, sessionId: SessionIdType, messages: SessionMessage[]) => void;
    handleSSEError: (sessionStoreGetState: SessionsStoreGetState, sessionId: SessionIdType, humanMessage: string) => void;
    _afterChatReponse: (sessionStoreGetState: SessionsStoreGetState, chatResponse: ChatResponse, onNewChatMessages: OnNewChatMessages | null, result: StoreFetchResult) => void;
    _doProxyApiRequests: (context: ChatContext, sessionId: SessionIdType, messageId: UUIDType, queries: IMessagePartProxiedQueryDefinition[]) => Promise<ProxiedQueryResultRequest>;
    chat: (sessionStoreGetState: SessionsStoreGetState, humanMessage: string, model: string | undefined, referenceMessageId: MessageIdType | undefined, referenceMessagePartId: MessageIdType | undefined, onNewChatMessages: OnNewChatMessages, additionalContext?: Record<string, any>, canonicalQuestionId?: string) => Promise<void>;
    patchMessage: (messageId: MessageIdType, messagePatch: MessagePatch) => Promise<void>;
    _fetchMessageHistory: () => Promise<void>;
    loadInitialMessageHistory: () => Promise<void>;
    loadNextMessageHistoryBatch: () => Promise<void>;
    addInsightToChat: (sessionStoreGetState: SessionsStoreGetState, insight: InsightSessionMessage) => void;
    chatMessages: () => SessionMessage[];
    messageHistoryMoreAvailable: () => boolean;
    setsyncedSessionId: (sessionId: SessionIdType) => void;
    loadSuggestedPrompts: (reason: RequestReason) => Promise<void>;
    setChatEntryText: (text: string) => void;
    reset: () => void;
    setMessageSubmitState: (messageId: MessageIdType, messageSubmitState: MessageSubmitState) => void;
    _updateInFlightMessages: (session: Session, newChatMessages: SessionMessage[]) => {
        filteredMessages: SessionMessage[];
        aiResponse: SessionMessage | undefined;
        humanResponse: SessionMessage | undefined;
    };
};
type ChatMessagesStoreType = StoreCommonState & ChatMessagesState & ChatMessagesActions;
export interface ChatMessagesStoreProps {
    uiSettings: UiSettings;
    backendSettings: BackendSettings;
    backendInterface: BackendInterface;
}
export type ChatMessagesStore = ReturnType<typeof createChatMessagesStore>;
export declare const createChatMessagesStore: (initProps: ChatMessagesStoreProps) => Omit<Omit<Omit<Omit<import("zustand").StoreApi<ChatMessagesStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: ChatMessagesStoreType | Partial<ChatMessagesStoreType> | ((state: ChatMessagesStoreType) => ChatMessagesStoreType | Partial<ChatMessagesStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<ChatMessagesStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: ChatMessagesStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: ChatMessagesStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<ChatMessagesStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: ChatMessagesStoreType | Partial<ChatMessagesStoreType> | ((state: import("immer").WritableDraft<ChatMessagesStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: ChatMessagesStoreType, previousSelectedState: ChatMessagesStoreType) => void): () => void;
        <U>(selector: (state: ChatMessagesStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
};
export declare const ChatMessagesContext: import("react").Context<(Omit<Omit<Omit<Omit<import("zustand").StoreApi<ChatMessagesStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: ChatMessagesStoreType | Partial<ChatMessagesStoreType> | ((state: ChatMessagesStoreType) => ChatMessagesStoreType | Partial<ChatMessagesStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<ChatMessagesStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: ChatMessagesStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: ChatMessagesStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<ChatMessagesStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: ChatMessagesStoreType | Partial<ChatMessagesStoreType> | ((state: import("immer").WritableDraft<ChatMessagesStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: ChatMessagesStoreType, previousSelectedState: ChatMessagesStoreType) => void): () => void;
        <U>(selector: (state: ChatMessagesStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
}) | null>;
export declare const useChatMessagesStore: <T>(selector: (state: ChatMessagesState & ChatMessagesActions) => T) => T;
export declare const useChatMessagesStoreWithoutSelector: () => ChatMessagesStoreType;
export declare const useChatMessageStoreHelpers: () => {
    subscribe: {
        (listener: (selectedState: ChatMessagesStoreType, previousSelectedState: ChatMessagesStoreType) => void): () => void;
        <U>(selector: (state: ChatMessagesStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
    getState: () => ChatMessagesStoreType;
    setState: (nextStateOrUpdater: ChatMessagesStoreType | Partial<ChatMessagesStoreType> | ((state: import("immer").WritableDraft<ChatMessagesStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined) => void;
};
export {};
