import { BackendSettings } from "../../contexts/BackendContext";
import { UiSettings } from "../../contexts/client/UiSettingsContext";
import { InsightSessionMessage, MessageIdType } from "../../types/SessionMessage";
import { BackendInterface } from "../../contexts/backend/BackendInterface";
import { StoreFetchResult, StoreFetchStatus } from "../../types/StoreFetchStatus";
import { StoreCommonState } from "../../types/StoreCommonState";
import { InsightPatch } from "../../types/Insights";
import { RequestReason } from "../../types/RequestReason";
import { IMessagePartPollInsights } from "../../types/SessionMessageParts";
export type InsightsPollingState = "idle" | "polling" | "success";
export type InsightsState = {
    insightsFetchResult: StoreFetchResult;
    insightsFetchStatus: StoreFetchStatus;
    insights: InsightSessionMessage[];
    insightsTitle: InsightSessionMessage | undefined;
    unreadCount: number | undefined;
    insightsLastSeen: Date | null;
    insightsMoreAvailable: boolean;
    insightsPollingState: InsightsPollingState;
    insightsPollingMessagePart: IMessagePartPollInsights | undefined;
};
export type InsightsReturn = {
    status: StoreFetchResult;
    insights: InsightSessionMessage[];
    unreadCount: number | undefined;
};
export declare const InsightsFeedFetchTypes: readonly ["first-page", "next-page", "refresh", "poll"];
export type InsightsFeedFetchType = (typeof InsightsFeedFetchTypes)[number];
export type InsightsActions = {
    _canLoadInsights: () => boolean;
    _loadSuccess: (title: InsightSessionMessage | undefined, insights: InsightSessionMessage[], unreadCount: number | undefined, lastSeen: Date | null, moreAvailable: boolean) => InsightsReturn;
    _loadFailure: (err: any) => InsightsReturn;
    _loadLiveInsights: (reason: RequestReason) => Promise<InsightsReturn | undefined>;
    _loadFeedInsights: (reason: RequestReason, fetchType: InsightsFeedFetchType) => Promise<InsightsReturn | undefined>;
    loadInsights: (reason: RequestReason, feedFetchType: InsightsFeedFetchType) => Promise<InsightsReturn | undefined>;
    _patchInsightInStore: (insightId: MessageIdType, insightPatch: InsightPatch) => void;
    patchInsight: (insightId: MessageIdType, insightPatch: InsightPatch) => Promise<void>;
    pollForInsights: (reason: RequestReason, mpPollInsights: IMessagePartPollInsights) => Promise<void>;
    reset: () => void;
};
export type InsightsStoreType = StoreCommonState & InsightsState & InsightsActions;
export interface InsightsStoreProps {
    uiSettings: UiSettings;
    backendSettings: BackendSettings;
    backendInterface: BackendInterface;
}
export type InsightsStore = ReturnType<typeof createInsightsStore>;
export declare const createInsightsStore: (initProps: InsightsStoreProps) => Omit<Omit<Omit<Omit<import("zustand").StoreApi<InsightsStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: InsightsStoreType | Partial<InsightsStoreType> | ((state: InsightsStoreType) => InsightsStoreType | Partial<InsightsStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<InsightsStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: InsightsStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: InsightsStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<InsightsStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: InsightsStoreType | Partial<InsightsStoreType> | ((state: import("immer").WritableDraft<InsightsStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: InsightsStoreType, previousSelectedState: InsightsStoreType) => void): () => void;
        <U>(selector: (state: InsightsStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
};
export declare const InsightsContext: import("react").Context<(Omit<Omit<Omit<Omit<import("zustand").StoreApi<InsightsStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: InsightsStoreType | Partial<InsightsStoreType> | ((state: InsightsStoreType) => InsightsStoreType | Partial<InsightsStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<InsightsStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: InsightsStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: InsightsStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<InsightsStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: InsightsStoreType | Partial<InsightsStoreType> | ((state: import("immer").WritableDraft<InsightsStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: InsightsStoreType, previousSelectedState: InsightsStoreType) => void): () => void;
        <U>(selector: (state: InsightsStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
}) | null>;
export declare function useInsightsStore<T>(selector: (state: InsightsState & InsightsActions) => T): T;
export declare const useInsightsStoreWithoutSelector: () => InsightsStoreType;
export declare const useInsightsStoreHelpers: () => {
    subscribe: {
        (listener: (selectedState: InsightsStoreType, previousSelectedState: InsightsStoreType) => void): () => void;
        <U>(selector: (state: InsightsStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
    getState: () => InsightsStoreType;
    setState: (nextStateOrUpdater: InsightsStoreType | Partial<InsightsStoreType> | ((state: import("immer").WritableDraft<InsightsStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined) => void;
};
