import { StoreFetchResult, StoreFetchStatus } from "../../types/StoreFetchStatus";
import { StoreCommonState } from "../../types/StoreCommonState";
import { RequestReason } from "../../types/RequestReason";
import { UiSettings } from "../../contexts/client/UiSettingsContext";
import { BackendSettings } from "../../contexts/BackendContext";
import { BackendInterface } from "../../contexts/backend/BackendInterface";
import { SessionIdType } from "../../types/Session";
import { AutocompleteSuggestion } from "../../types/AutocompleteSuggestion";
export type AutocompleteState = {
    autocompleteFetchResult: StoreFetchResult;
    autocompleteFetchStatus: StoreFetchStatus;
    autocompleteSuggestions: AutocompleteSuggestion[];
    autocompleteDebounce: ((reason: RequestReason, message: string) => Promise<void>) | undefined;
    _syncedSessionId: SessionIdType;
};
export type AutocompleteActions = {
    setSyncedSessionId: (sessionId: SessionIdType) => void;
    _canLoadAutocomplete: () => boolean;
    loadAutocompleteSuggestions: (reason: RequestReason, message: string) => Promise<void>;
    debouncedLoadAutocompleteSuggestions: (reason: RequestReason, message: string) => Promise<void>;
    reset: () => void;
};
type AutocompleteStoreType = StoreCommonState & AutocompleteState & AutocompleteActions;
export interface AutocompleteStoreProps {
    uiSettings: UiSettings;
    backendSettings: BackendSettings;
    backendInterface: BackendInterface;
}
export type AutocompleteStore = ReturnType<typeof createAutocompleteStore>;
export declare const createAutocompleteStore: (initProps: AutocompleteStoreProps) => Omit<Omit<Omit<Omit<import("zustand").StoreApi<AutocompleteStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: AutocompleteStoreType | Partial<AutocompleteStoreType> | ((state: AutocompleteStoreType) => AutocompleteStoreType | Partial<AutocompleteStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<AutocompleteStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: AutocompleteStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: AutocompleteStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<AutocompleteStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: AutocompleteStoreType | Partial<AutocompleteStoreType> | ((state: import("immer").WritableDraft<AutocompleteStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: AutocompleteStoreType, previousSelectedState: AutocompleteStoreType) => void): () => void;
        <U>(selector: (state: AutocompleteStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
};
export declare const AutocompleteContext: import("react").Context<(Omit<Omit<Omit<Omit<import("zustand").StoreApi<AutocompleteStoreType>, "setState"> & {
    setState<A extends string | {
        type: string;
    }>(partial: AutocompleteStoreType | Partial<AutocompleteStoreType> | ((state: AutocompleteStoreType) => AutocompleteStoreType | Partial<AutocompleteStoreType>), replace?: boolean | undefined, action?: A | undefined): void;
}, "persist"> & {
    persist: {
        setOptions: (options: Partial<import("zustand/middleware").PersistOptions<AutocompleteStoreType, unknown>>) => void;
        clearStorage: () => void;
        rehydrate: () => Promise<void> | void;
        hasHydrated: () => boolean;
        onHydrate: (fn: (state: AutocompleteStoreType) => void) => () => void;
        onFinishHydration: (fn: (state: AutocompleteStoreType) => void) => () => void;
        getOptions: () => Partial<import("zustand/middleware").PersistOptions<AutocompleteStoreType, unknown>>;
    };
}, "setState"> & {
    setState(nextStateOrUpdater: AutocompleteStoreType | Partial<AutocompleteStoreType> | ((state: import("immer").WritableDraft<AutocompleteStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined): void;
}, "subscribe"> & {
    subscribe: {
        (listener: (selectedState: AutocompleteStoreType, previousSelectedState: AutocompleteStoreType) => void): () => void;
        <U>(selector: (state: AutocompleteStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
}) | null>;
export declare function useAutocompleteStore<T>(selector: (state: AutocompleteState & AutocompleteActions) => T): T;
export declare const useAutocompleteStoreWithoutSelector: () => AutocompleteStoreType;
export declare const useAutocompleteStoreHelpers: () => {
    subscribe: {
        (listener: (selectedState: AutocompleteStoreType, previousSelectedState: AutocompleteStoreType) => void): () => void;
        <U>(selector: (state: AutocompleteStoreType) => U, listener: (selectedState: U, previousSelectedState: U) => void, options?: {
            equalityFn?: ((a: U, b: U) => boolean) | undefined;
            fireImmediately?: boolean;
        } | undefined): () => void;
    };
    getState: () => AutocompleteStoreType;
    setState: (nextStateOrUpdater: AutocompleteStoreType | Partial<AutocompleteStoreType> | ((state: import("immer").WritableDraft<AutocompleteStoreType>) => void), shouldReplace?: boolean | undefined, action?: string | {
        type: string;
    } | undefined) => void;
};
export {};
