import { OnChatDisplayStateChange } from "../types/ChatDisplayState";
import { OnChatNavigateTo } from "../types/ChatNavigation";
import { FetchInsightsFn } from "./useExternalInsightsFetch";
import { OnFetchAuthTokenFnChange } from "./useTokenProvider";
import { FetchAuthTokenFn } from "../types/TokenProvider";
import log from "loglevel";
import { ApiProxyRequestFn, OnApiProxyRequestFnChange } from "../types/ApiProxyRequest";
type SetLogLevelFn = (level: log.LogLevelDesc) => void;
export interface IExternalInteractions {
    setDisplayState: OnChatDisplayStateChange;
    navigateTo: OnChatNavigateTo;
    fetchInsights: FetchInsightsFn;
    fetchAuthToken: FetchAuthTokenFn | undefined;
    packageVersion: string;
    backendInterfaceName: string;
    setLogLevel: SetLogLevelFn;
    apiProxyRequest: ApiProxyRequestFn | undefined;
}
declare global {
    interface Window {
        GmsChatUi?: IExternalInteractions;
    }
}
declare const useExternalInteractions: (setDisplayState: OnChatDisplayStateChange, onNavigateTo: OnChatNavigateTo, onFetchAuthTokenFnChange: OnFetchAuthTokenFnChange, onApiProxyRequestFnChange: OnApiProxyRequestFnChange) => void;
export default useExternalInteractions;
