import { InsightSessionMessage, SessionMessage } from "../types/SessionMessage";
import { ChatDisplayState } from "../types/ChatDisplayState";
import { IHyperLinkOptions, MessagePartHyperLinkTarget } from "../types/SessionMessageParts";
export interface DisplayStateChangeDetail {
    prevDisplayState: ChatDisplayState;
    newDisplayState: ChatDisplayState;
}
export interface ChatNavigateDetail {
    target: string;
    targetMeta?: MessagePartHyperLinkTarget;
}
export interface ChatInsightsFetchedDetail {
    insights: InsightSessionMessage[];
    unreadCount: number | undefined;
}
export interface ChatInsightsUnreadDetail {
    unreadCount: number | undefined;
}
declare const useChatEvents: () => {
    sendChatMessageParts: (message: SessionMessage) => void;
    sendChatClose: () => void;
    sendChatDisplayStateChange: (prevDisplayState: ChatDisplayState, newDisplayState: ChatDisplayState) => void;
    sendChatNavigate: (url: string, link_options: IHyperLinkOptions | undefined) => void;
    sendChatInitialised: () => void;
    sendInsightsFetched: (insights: InsightSessionMessage[], unreadCount: number | undefined) => void;
    sendInsightsUnreadChanged: (unreadCount: number | undefined) => void;
};
export default useChatEvents;
