import { SessionIdType, SessionViewState } from "../../types/Session";
import React from "react";
interface ViewSessionEntryProps {
    busy: boolean;
    value: string;
    activeSession: boolean | undefined;
    editable: boolean | undefined;
    favorited: boolean;
    skeleton: boolean;
    onFavoriteClick?: () => void;
    onEditClick?: () => void;
    onDeleteClick?: () => void;
    onSelectClick?: (showChat: boolean) => void;
}
export declare const ViewSessionEntry: ({ busy, value, activeSession, editable, favorited, skeleton, onFavoriteClick, onEditClick, onDeleteClick, onSelectClick, }: ViewSessionEntryProps) => React.JSX.Element;
export interface ChatSessionEntryProps {
    /** The session name */
    sessionName: string;
    /** UUID for session */
    sessionId: SessionIdType;
    /** Is this in the favorites list */
    favorited: boolean;
    /** Is this session updated to the backend */
    busy: boolean;
    /** Is user viewing or prompted to delete/rename session */
    viewState: SessionViewState;
    /** User clicked on this session */
    onClick: (showChat: boolean) => void;
    /** Is this the active (selected) session */
    activeSession?: boolean;
    /** Is there a chat request for this session */
    sessionInFlight?: boolean;
    /** Is this session name editable (ie not a conversation starter) */
    editable?: boolean;
}
declare const ChatSessionEntry: ({ sessionName, sessionId, favorited, busy, viewState, onClick, activeSession, sessionInFlight, editable, }: ChatSessionEntryProps) => React.JSX.Element;
export default ChatSessionEntry;
