import { GmsChatAppProps } from "./GmsChatApp";
import { GmsClient } from "../../contexts/BackendContext";
import { ChatContext } from "../../types/ChatContext";
import { ChatDisplayState } from "../../types/ChatDisplayState";
import { ComponentType } from "react";
import React from "react";
import { FetchAuthTokenFn } from "../../types/TokenProvider";
import { BackendInterfaceBuilder } from "../../contexts/backend/BackendInterfaceProvider";
import { PropUiSettings } from "../../contexts/client/UiSettingsContext";
import log from "loglevel";
import { ApiProxyRequestFn } from "../../types/ApiProxyRequest";
export declare const DisplayStateStorageKey = "gms_chat_display_state";
interface GmsChatWindowInternalProps extends Omit<GmsChatAppProps, "setDisplayState" | "navigateTo" | "mockBackend" | "tokenProvider" | "backendSettings"> {
    userId: string;
    chatContext: ChatContext | undefined;
    userLocale: string | undefined;
    authToken?: string | FetchAuthTokenFn;
    initialDisplayState: ChatDisplayState | undefined;
    logLevel?: log.LogLevelDesc;
    apiProxyRequest: ApiProxyRequestFn | undefined;
}
export declare const GmsChatWindowInternal: ({ backendUrl, authToken, userId, gmsClient, showSidebar, slideOverSidebar, showSuggestions, showConversationStarter, fetchHistory, showHeading, roundedCorners, chatContext, enableInsights, enableChat, enableFeedback, initialDisplayState, showChatInput, backendInterfaceBuilder, uiSettings, userLocale, logLevel, enableAutocomplete, apiProxyRequest, }: GmsChatWindowInternalProps) => React.JSX.Element;
export interface GmsChatBaseProps {
    backendUrl: string;
    authToken: string | FetchAuthTokenFn;
    userId: string;
    gmsClient: GmsClient;
    showSidebar?: boolean;
    slideOverSidebar?: boolean;
    showSuggestions?: boolean;
    showConversationStarter?: boolean;
    fetchHistory?: boolean;
    chatContext?: ChatContext;
    enableInsights?: boolean;
    enableChat?: boolean;
    enableFeedback?: boolean;
    showChatInput?: boolean;
    backendInterfaceBuilder?: BackendInterfaceBuilder;
    uiSettings?: PropUiSettings;
    userLocale?: string;
    logLevel?: log.LogLevelDesc;
    enableAutocomplete?: boolean;
    apiProxyRequest?: ApiProxyRequestFn;
}
export interface GmsChatWindowProps extends GmsChatBaseProps {
    showHeading?: boolean;
    roundedCorners?: boolean;
    initialDisplayState?: ChatDisplayState;
    disableShadowDom?: boolean;
}
declare const GmsChatWindow: ComponentType<GmsChatWindowProps>;
export default GmsChatWindow;
