import React from "react";
import { BackendSettings, GmsClient } from "../../contexts/BackendContext";
import "../../hooks/cache/cleanLocalStorage";
import { BackendInterfaceBuilder } from "../../contexts/backend/BackendInterfaceProvider";
import { ClientConfigOverrides } from "../../contexts/client/UiSettingsContext";
export declare const GmsChatAppGlobalStyle: import("styled-components").GlobalStyleComponent<{}, import("styled-components").DefaultTheme>;
export interface GmsChatAppProps {
    backendUrl: string;
    mockBackend: boolean;
    gmsClient: GmsClient;
    showSidebar: boolean | undefined;
    slideOverSidebar: boolean | undefined;
    showSuggestions: boolean | undefined;
    showConversationStarter: boolean | undefined;
    fetchHistory: boolean | undefined;
    showHeading: boolean | undefined;
    roundedCorners: boolean | undefined;
    enableInsights: boolean | undefined;
    enableChat: boolean | undefined;
    enableFeedback: boolean | undefined;
    showChatInput: boolean | undefined;
    uiSettings: ClientConfigOverrides | undefined;
    enableAutocomplete: boolean | undefined;
    backendInterfaceBuilder: BackendInterfaceBuilder | undefined;
    backendSettings: BackendSettings;
}
export declare const GmsChatApp: ({ backendUrl, mockBackend, children, gmsClient, uiSettings, backendInterfaceBuilder, backendSettings, ...rest }: GmsChatAppProps & {
    children?: React.ReactNode;
}) => React.JSX.Element;
export default GmsChatApp;
