import React from "react";
import { SessionIdType } from "../../types/Session";
import { ChatDisplayState, OnChatDisplayStateChange } from "../../types/ChatDisplayState";
import { ChatNavDestination, OnChatNavigateTo } from "../../types/ChatNavigation";
import { SessionMessage } from "../../types/SessionMessage";
import { OnMessagePatch } from "../../types/MessagePatch";
import { SuggestedPrompt } from "../../types/SuggestedPrompt";
interface ChatWindowProps {
    displayState: ChatDisplayState;
    onDisplayStateChange: OnChatDisplayStateChange;
    navDestination: ChatNavDestination;
    onNavigateTo: OnChatNavigateTo;
    chatMessages: SessionMessage[];
    onMessagePatch: OnMessagePatch;
    loadNextMessageHistoryBatch: () => void;
    isMessageHistoryLoading: boolean;
    isMessageInFlight: boolean;
    inFlightSessionId: SessionIdType | null;
    moreMessageHistoryAvailable: boolean;
    suggestions: SuggestedPrompt[];
    isSuggestionsLoading: boolean;
}
declare const ChatWindow: ({ displayState, onDisplayStateChange, navDestination, onNavigateTo, chatMessages, onMessagePatch, loadNextMessageHistoryBatch, isMessageHistoryLoading, isMessageInFlight, inFlightSessionId, moreMessageHistoryAvailable, suggestions, isSuggestionsLoading, }: ChatWindowProps) => React.JSX.Element;
export default ChatWindow;
