import React from "react";
import type { StoryObj } from "@storybook/react-vite";
import { StoreFetchResult, StoreFetchStatus } from "../../types/StoreFetchStatus";
import type { SessionMessageJson } from "../../backends/copilot/interface/SessionMessageBuilder";
interface WrappedInsightsPanelProps {
    insightsJson: SessionMessageJson[];
    insightsTitleJson: SessionMessageJson | undefined;
    insightsFetchResult: StoreFetchResult;
    insightsFetchStatus: StoreFetchStatus;
}
declare const meta: {
    title: string;
    component: ({ insightsJson, insightsTitleJson, insightsFetchResult, insightsFetchStatus, }: WrappedInsightsPanelProps) => React.JSX.Element;
    parameters: {
        layout: string;
    };
    tags: string[];
};
export default meta;
type Story = StoryObj<typeof meta>;
export declare const WithBackendTitle: Story;
export declare const DefaultTitle: Story;
export declare const FirstLoading: Story;
export declare const NoInsights: Story;
