import { SessionMessage } from "../../../types/SessionMessage";
import { SpeakerType } from "../../../types/SpeakerType";
import { IMessagePartBase } from "../../../types/SessionMessageParts";
import { MessageSubmitState } from "../../../types/MessageSubmitState";
export interface MessagePartDisplayFnProps<T extends IMessagePartBase> {
    messagePart: T;
    speaker: SpeakerType;
    prevMessagePartKind: string | undefined;
    isLastMessage?: boolean;
    message?: SessionMessage;
    messageSubmitState?: MessageSubmitState;
    setMessageState?: (key: string, value: string | undefined, label: string | undefined, required: boolean) => void;
}
export declare const MessagePartDummyDisplay: () => null;
export type MessagePartDisplayFn<T extends IMessagePartBase> = React.FunctionComponent<MessagePartDisplayFnProps<T>>;
type MessagePartDisplayHandlers = Record<string, MessagePartDisplayFn<any>>;
export declare const messagePartDisplayHandlers: MessagePartDisplayHandlers;
export {};
