import React from "react";
export interface IFrameProps extends React.DetailedHTMLProps<React.IframeHTMLAttributes<HTMLIFrameElement>, HTMLIFrameElement> {
    /**
     * The `head` prop is a dom node that gets inserted before the children of the frame.
     */
    head?: React.ReactNode;
    /**
     * The `initialContent` props is the initial html injected into frame.
     * It is only injected once,
     * but allows you to insert any html into the frame (e.g. a [`<head>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/head) tag, [`<script>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/script) tags, etc).
     * Note that it does not update if you change the prop.
     *
     * Defaults to `<!DOCTYPE html><html><head></head><body></body></html>`
     */
    initialContent?: string;
    /**
     * The `mountTarget` attribute is a css selector (`#target`/`.target`) that specifies the child within the initial content of the iframe to be mounted.
     */
    mountTarget?: string;
}
declare const IFrame: React.ForwardRefExoticComponent<Omit<IFrameProps, "ref"> & React.RefAttributes<HTMLIFrameElement>>;
export default IFrame;
