import { SessionMessage } from "../../types/SessionMessage";
import { SpeakerType } from "../../types/SpeakerType";
import { ReactNode } from "react";
import React from "react";
import { SessionIdType } from "../../types/Session";
interface InnerChatItemProps {
    innerId?: string;
    speaker: SpeakerType;
    isSkeleton: boolean;
    innerRef?: React.RefObject<HTMLDivElement>;
    children: ReactNode;
}
export declare const InnerChatItem: ({ innerId, speaker, isSkeleton, innerRef, children, }: InnerChatItemProps) => React.JSX.Element;
export interface ChatItemProps {
    message: SessionMessage;
    innerRef?: (instance: HTMLDivElement | null) => void;
    isSkeleton: boolean;
    feedbackRow?: ReactNode;
    isLastMessage?: boolean;
    sessionId: SessionIdType;
}
declare const ChatItem: ({ message, innerRef, isSkeleton, feedbackRow, isLastMessage, sessionId, }: ChatItemProps) => React.JSX.Element;
interface ChatLoadingItemProps {
    speaker: SpeakerType;
}
export declare const ChatLoadingItem: ({ speaker }: ChatLoadingItemProps) => React.JSX.Element;
export default ChatItem;
