import { DefaultTheme } from "styled-components";
import { SessionMessage } from "../../types/SessionMessage";
import { SpeakerType } from "../../types/SpeakerType";
import React from "react";
import { SessionMessagePartFilterDisplayAs } from "../../types/SessionMessagePartsFilter";
import { MessagePartDisplayArea } from "../../types/SessionMessageParts";
import { SessionIdType } from "../../types/Session";
interface ChatMessageContainerProps {
    speaker: SpeakerType;
    displayArea: MessagePartDisplayArea;
}
export declare const ChatMessageContainer: import("styled-components").StyledComponent<React.ForwardRefExoticComponent<Omit<{
    [x: string]: /*elided*/ any;
    theme: DefaultTheme;
    as: string | React.ComponentClass<any, any> | React.FunctionComponent<any>;
    forwardedAs: string | React.ComponentClass<any, any> | React.FunctionComponent<any>;
}, "ref"> & React.RefAttributes<HTMLElement>>, DefaultTheme, ChatMessageContainerProps, never>;
interface ChatBubbleFlexProps {
    speaker: SpeakerType;
    displayArea: MessagePartDisplayArea;
    children: React.ReactNode;
    mt?: string;
}
export declare const ChatBubbleFlex: (props: ChatBubbleFlexProps) => React.JSX.Element;
interface ChatBubbleInnerProps {
    /** Message to display in the bubble */
    message: SessionMessage;
    /** Display bubble as a skeleton */
    isSkeleton: boolean;
    isLastMessage?: boolean;
    displayAs: SessionMessagePartFilterDisplayAs;
    displayArea: MessagePartDisplayArea;
}
export interface ChatBubbleProps extends ChatBubbleInnerProps {
    sessionId: SessionIdType;
}
/** Bubble containing a SessionMessage */
export declare const ChatBubble: ({ message, isSkeleton, isLastMessage, displayAs, displayArea, sessionId, }: ChatBubbleProps) => React.JSX.Element;
export default ChatBubble;
