import { Element as HRPElement, HTMLReactParserOptions } from "html-react-parser";
import { SpeakerType } from "../../types/SpeakerType";
import { IMessagePartExplanation, IMessagePartSummary, IMessagePartTable, IMessagePartText, IMessagePartTitle } from "../../types/SessionMessageParts";
import { MessageSubmitState } from "../../types/MessageSubmitState";
export type HtmlMessagePart = IMessagePartText | IMessagePartTable | IMessagePartExplanation | IMessagePartTitle | IMessagePartSummary;
export interface ReplacerParams<ExtraParams extends object> {
    domNode: HRPElement;
    options: HTMLReactParserOptions;
    extraParams: ExtraParams;
    speaker: SpeakerType;
    messagePart: HtmlMessagePart;
    messageSubmitState: MessageSubmitState;
}
export type AiHtmlElementHandler<ExtraParams extends object> = {
    match: (domNode: HRPElement) => boolean;
    replacer: (params: ReplacerParams<ExtraParams>) => JSX.Element | string | null | boolean | object | void;
};
interface InnerElementsProps<ExtraParams extends object> {
    contentHtml: string;
    speaker: SpeakerType;
    elementHandlers: AiHtmlElementHandler<ExtraParams>[];
    extraParams: ExtraParams;
    messagePart: HtmlMessagePart;
    messageSubmitState: MessageSubmitState;
}
declare const AiHtmlElements: <ExtraParams extends object>({ contentHtml, speaker, elementHandlers, extraParams, messagePart, messageSubmitState, }: InnerElementsProps<ExtraParams>) => string | import("react").JSX.Element | import("react").JSX.Element[];
export default AiHtmlElements;
