import React from "react";
import { Element as HRPElement } from "html-react-parser";
import { AiContentExtraParams } from "./AiHtmlCommon";
import { ReplacerParams } from "./AiHtmlElements";
import { DefaultTheme } from "styled-components";
export declare const HtmlPComponent: ({ domNode, options }: ReplacerParams<AiContentExtraParams>) => React.JSX.Element;
export declare const HtmlSmallComponent: ({ domNode, options }: ReplacerParams<AiContentExtraParams>) => React.JSX.Element;
export declare const HtmlIconComponent: ({ domNode }: ReplacerParams<AiContentExtraParams>) => React.JSX.Element;
export declare const HtmlLegacyTitleLinkComponent: ({ domNode, speaker, messagePart, }: ReplacerParams<AiContentExtraParams>) => React.JSX.Element;
export interface HtmlLinkAndPromptComponentProps extends ReplacerParams<AiContentExtraParams> {
    useGetTheme: (domNode: HRPElement) => DefaultTheme;
}
export declare const HtmlHyperlinkComponent: ({ domNode, speaker, useGetTheme, messagePart, }: HtmlLinkAndPromptComponentProps) => React.JSX.Element;
export declare const HtmlAnchorComponent: ({ domNode, ...otherProps }: HtmlLinkAndPromptComponentProps) => React.JSX.Element;
export declare const HtmlPromptComponent: ({ domNode, speaker, useGetTheme, messagePart, }: HtmlLinkAndPromptComponentProps) => React.JSX.Element;
export declare const HtmlSubmitComponent: ({ domNode, speaker, useGetTheme, messagePart, messageSubmitState, }: HtmlLinkAndPromptComponentProps) => React.JSX.Element;
export declare const HtmlRowComponent: ({ domNode, options }: ReplacerParams<AiContentExtraParams>) => React.JSX.Element;
export declare const HtmlColumnComponent: ({ domNode, options }: ReplacerParams<AiContentExtraParams>) => React.JSX.Element;
