import React from "react";
import type { StoryObj } from "@storybook/react-vite";
import { SpeakerType } from "../../types/SpeakerType";
import { MessageSubmitState } from "../../types/MessageSubmitState";
interface WrappedAiContentDivProps {
    speaker?: SpeakerType;
    html: string;
    messageSubmitState?: MessageSubmitState;
}
declare const meta: {
    title: string;
    component: ({ html, speaker, messageSubmitState, }: WrappedAiContentDivProps) => React.JSX.Element;
    tags: string[];
    parameters: {
        layout: string;
    };
};
export default meta;
type Story = StoryObj<typeof meta>;
export declare const Primary: Story;
export declare const HeadingH1: Story;
export declare const HeadingH2: Story;
export declare const HeadingH3: Story;
export declare const HeadingH4: Story;
export declare const Paragraph: Story;
export declare const ParagraphBold: Story;
export declare const ParagraphItalic: Story;
export declare const ParagraphStrikethrough: Story;
export declare const InlineCode: Story;
export declare const ParagraphSmall: Story;
export declare const ParagraphLineBreak: Story;
export declare const HorizontalRule: Story;
export declare const BlockQuote: Story;
export declare const CodeBlock: Story;
export declare const UnorderedList: Story;
export declare const OrderedList: Story;
export declare const MixedList: Story;
export declare const WithIcon: Story;
export declare const Link: Story;
export declare const SmallLink: Story;
export declare const Anchor: Story;
export declare const LinkButton: Story;
export declare const Prompt: Story;
export declare const SmallPrompt: Story;
export declare const PromptButton: Story;
export declare const SubmitButton: Story;
export declare const RowLayout: Story;
export declare const ColumnLayout: Story;
export declare const TableLayout: Story;
export declare const HorizontalScrollTableLayout: Story;
export declare const Image: Story;
export declare const DataURIImageEmbedding: Story;
