import { ClientConfigOverrides, UiSettings } from "../../contexts/client/UiSettingsContext";
import { GmsClient } from "../BackendContext";
import { ServerConfig } from "../../types/ServerConfig";
export declare const mergeIfSet: (prop: boolean | undefined, fallback: boolean, validClient: boolean, needsValidClient: boolean) => boolean;
/**
 * Merges UI settings based on client configuration and provided props.
 *
 * Start with the in-code client config, the override with props.
 * Some settings require a valid GMS client to be enabled.
 *
 * settingOverrides allows you to override any settings with
 * no checks other than the setting is not undefined.
 */
export declare const mergeSettings: (gmsClient: GmsClient, { showSidebar, slideOverSidebar, showSuggestions, showConversationStarter, fetchHistory, showHeading, roundedCorners, enableInsights, enableChat, enableFeedback, showChatInput, enableAutocomplete, }: ClientConfigOverrides, settingOverrides: ClientConfigOverrides | undefined, clientProductName: string, setClientProductName: (name: string) => void, serverConfig: ServerConfig, setServerConfig: (config: ServerConfig) => void) => UiSettings;
