import React from "react";
import { ClientTheme } from "../../themes/default";
import { SessionMessagePartFilter } from "../../types/SessionMessagePartsFilter";
import { ButtonStyle } from "../../components/buttons/AiKitButton.styles";
import { GmsClient } from "../BackendContext";
import { ServerConfig } from "../../types/ServerConfig";
type InsightFetchMode = "feed" | "live";
type SuggestedPromptsFetchMode = "context-dependent" | "fixed";
export interface NonPropSettings {
    insightFetchMode: InsightFetchMode;
    suggestedPromptsFetchMode: SuggestedPromptsFetchMode;
    enableUnreadInsights: boolean;
    enableInsightToChat: boolean;
    messagePartFilter: SessionMessagePartFilter;
    enableIntacctFeedbackRow: boolean;
    chatBubbleWidth: string;
    dateSeparatedInsights: boolean;
    enableSlowProcessingMessage: boolean;
    theme: ClientTheme;
    chatBubbleTheme: ClientTheme;
    showMinimiseButton: boolean;
    showCloseButton: boolean;
    showGoBackButton: boolean;
    showAiWarning: boolean;
    enableNewChat: boolean;
    enableSingleSession: boolean;
    showPrivacyLink: boolean;
    chatInputNewChatButtonStyle: ButtonStyle;
    welcomeText: string;
    promptText: string;
    instancePrefix: string;
    componentTitle: string;
    enableExtrasPanel: boolean;
    refreshIntervalSeconds: number | undefined;
    useStreamingChat: boolean;
    loadTriggersBeforeDisplay: boolean;
}
export interface PropUiSettings {
    showSidebar: boolean;
    slideOverSidebar: boolean;
    showSuggestions: boolean;
    showConversationStarter: boolean;
    fetchHistory: boolean;
    showHeading: boolean;
    roundedCorners: boolean;
    enableInsights: boolean;
    enableChat: boolean;
    enableFeedback: boolean;
    showChatInput: boolean;
    enableAutocomplete: boolean;
}
export interface OtherSettings {
    clientProductName: string;
    setClientProductName: (name: string) => void;
    setServerConfig: (config: ServerConfig) => void;
}
export type ClientConfig = NonPropSettings & PropUiSettings;
export type UiSettings = ClientConfig & OtherSettings;
export type ClientConfigOverrides = Partial<ClientConfig>;
declare const UiSettingsContext: React.Context<UiSettings>;
export declare const UiSettingsProvider: React.Provider<UiSettings>;
export default UiSettingsContext;
export declare const useUiSettingsSetup: (gmsClient: GmsClient, rest: ClientConfigOverrides, uiSettings: Partial<ClientConfig> | undefined) => UiSettings;
