import { ChatRequest, ChatResponse, ProxiedQueryResultRequest } from "../../types/ChatRequest";
import { InsightPatch, InsightRequestTypes } from "../../types/Insights";
import { MessagePatch } from "../../types/MessagePatch";
import { Session, SessionIdType, SessionPatch } from "../../types/Session";
import { InsightSessionMessage, SessionMessage } from "../../types/SessionMessage";
import { StarterSessionMessage } from "../../types/StarterSessionMessage";
import { SuggestedPrompt } from "../../types/SuggestedPrompt.ts";
import { BackendSettings } from "../BackendContext";
import { RequestReason } from "../../types/RequestReason.ts";
import { ChatContext } from "../../types/ChatContext.ts";
import { AutocompleteSuggestion } from "../../types/AutocompleteSuggestion.ts";
import { ServerConfig } from "../../types/ServerConfig.ts";
export interface BackendInterface {
    chat: (request: ChatRequest | ProxiedQueryResultRequest, onAsyncMessages?: (sessionId: SessionIdType, messages: SessionMessage[]) => void, onAsyncError?: (sessionId: SessionIdType, humanMessage: string) => void, streaming?: boolean) => Promise<ChatResponse>;
    getMessages: (sessionId: SessionIdType, lastSeen: Date | null, limit: number, reason?: RequestReason) => Promise<SessionMessage[]>;
    patchMessage: (messageId: string, messagePatch: MessagePatch) => Promise<void>;
    getSessions: (reason: RequestReason) => Promise<Session[]>;
    patchSession: (sessionId: string, sessionPatch: SessionPatch) => Promise<void>;
    deleteSession: (sessionId: string) => Promise<void>;
    getInsights: (request: InsightRequestTypes, reason?: RequestReason) => Promise<InsightSessionMessage[]>;
    getInsightsFeed: (lastSeen: Date | null, limit: number, reason?: RequestReason) => Promise<{
        insights: InsightSessionMessage[];
        unreadCount: number;
    }>;
    patchInsights: (insightId: string, insightPatch: InsightPatch) => Promise<void>;
    getConversationStarter: (reason: RequestReason) => Promise<StarterSessionMessage>;
    getSuggestedPrompts: (reason: RequestReason) => Promise<SuggestedPrompt[]>;
    postSuggestedPrompts: (context: ChatContext, reason: RequestReason) => Promise<SuggestedPrompt[]>;
    name: string;
    setBackendSettings: (settings: BackendSettings) => void;
    hasValidChatContext: () => boolean;
    postAutocompleteSuggestions: (reason: RequestReason, sessionId: string, message: string) => Promise<AutocompleteSuggestion[]>;
    getServerConfig: (reason: RequestReason) => Promise<ServerConfig>;
}
