import React from "react";
import { TokenProvider } from "../types/TokenProvider";
import { ChatContext } from "../types/ChatContext";
import { ApiProxyRequestFn } from "../types/ApiProxyRequest";
export declare const GmsClients: readonly ["sdmo_v1", "sip_v1", "sna_v1", "sbca_v1", "sif_v1", "x3_v1", "demo_v1", "orchestration_v0", "orchestration_v1", "mcp_v1"];
export type GmsClient = (typeof GmsClients)[number];
export declare const isValidClient: (client: string | undefined) => boolean;
export interface BackendSettings {
    url: string;
    tokenProvider: TokenProvider;
    userId: string;
    gmsClient: GmsClient | undefined;
    chatContext: ChatContext;
    userLocale: string;
    apiProxyRequest: ApiProxyRequestFn | undefined;
    instancePrefix: string;
}
export declare const defaultBackendSettings: BackendSettings;
declare const BackendContext: React.Context<BackendSettings>;
export declare const BackendProvider: React.Provider<BackendSettings>;
export default BackendContext;
