import { ButtonBackground, ButtonSize } from "../buttons/AiKitButton.styles";
import { DefaultThemeStylingKey } from "../../themes/default";
export type AiKitPillStatus = "neutral" | "positive" | "negative" | "warning" | "information" | "neutralWhite";
interface PillStateColors {
    normalBorder: string;
    normalBackground: string;
    normalText: string;
    filledBorder: string;
    filledBackground: string;
    filledText: string;
}
type PillStyleStateColors = {
    [key in AiKitPillStatus]: PillStateColors;
};
type PillBackgroundStyleStateColors = {
    [key in ButtonBackground]: PillStyleStateColors;
};
export declare const aiKitPillStyleColors: PillBackgroundStyleStateColors;
interface AiKitPillSize {
    minHeight: string;
    padding: string;
    fontSizeKey: DefaultThemeStylingKey;
}
export type AiKitPillSizes = {
    [key in ButtonSize]: AiKitPillSize;
};
export declare const aiKitPillSizes: AiKitPillSizes;
export {};
