import { SageIconType } from "../../types/SageIconType";
import { SpaceProps } from "styled-system";
import React from "react";
export interface ContextMenuItemProps {
    icon?: SageIconType;
    text: string;
    ariaLabel?: string;
    onClick?: () => void;
    dataRole?: string;
}
export declare const ContextMenuItem: ({ icon, text, ariaLabel, onClick, dataRole, }: ContextMenuItemProps) => React.JSX.Element;
export declare const ContextMenuItemDivider: () => React.JSX.Element;
export interface MenuItemProps {
    id: string;
    menuItems: React.ReactNode[];
    setMenuOpen: (state: boolean) => void;
    position: "top" | "bottom";
}
export interface ContextMenuProps extends SpaceProps {
    icon: "ellipsis-horizontal" | "ellipsis-vertical" | "settings";
    mode?: "icon" | "children";
    children?: React.ReactNode;
    position?: "top" | "bottom";
    ariaLabel: string;
    ariaDescribedBy?: string;
    menuItems: React.ReactNode[];
    onMenuOpenClose?: (open: boolean) => void;
    dataRole?: string;
    disabled?: boolean;
    fill?: string;
}
declare const ContextMenu: ({ icon, ariaLabel, ariaDescribedBy, menuItems, onMenuOpenClose, dataRole, disabled, position, children, fill, mode, ...rest }: ContextMenuProps) => React.JSX.Element;
export default ContextMenu;
