import { ButtonBackground } from "../buttons/AiKitButton.styles";
import { ReactNode } from "react";
import { LinkStyle } from "./AiKitLink.styles";
import { SageIconType } from "../../types/SageIconType";
import React from "react";
import { LayoutProps } from "styled-system";
export interface StyledLinkProps extends LayoutProps {
    linkStyle: LinkStyle;
    disabled?: boolean;
    linkBackground: ButtonBackground;
    fontSize?: string;
    children: ReactNode;
}
export interface AiKitLinkProps extends StyledLinkProps {
    url?: string;
    onClick?: React.MouseEventHandler<HTMLAnchorElement>;
    tabIndex?: number;
    showLinkIcon?: boolean;
    icon?: SageIconType;
    iconFill?: string;
    iconSize?: number;
    title?: string;
    innerRef?: React.RefObject<HTMLAnchorElement> | React.RefCallback<HTMLAnchorElement>;
}
declare const AiKitLink: ({ disabled, url, onClick, showLinkIcon, icon, iconFill, iconSize, children, innerRef, title, ...rest }: AiKitLinkProps) => React.JSX.Element;
export default AiKitLink;
