import React from "react";
type TextInputSize = "s" | "m" | "l";
export interface TextInputProps {
    /** Value to edit */
    value: string;
    /** Called to store value on change */
    setValue: (newValue: string) => void;
    /** Called when enter pressed */
    onValueEntered: (value: string) => void;
    /** Called when escape pressed */
    onCancel: () => void;
    size: TextInputSize;
    borderColor: string;
    borderWidth: string;
    placeholder?: string;
}
declare const TextInput: ({ value, setValue, onValueEntered, onCancel, size, borderColor, borderWidth, placeholder, }: TextInputProps) => React.JSX.Element;
export default TextInput;
