import { LayoutProps, SpaceProps } from "styled-system";
import React from "react";
export declare const useTextAreaVerticalDimensions: () => {
    verticalPadding: number;
    outerMaxHeight: number;
    outerBorderWidth: number;
    innerMinHeight: number;
    innerMaxHeight: number;
};
export interface TextAreaProps extends SpaceProps, LayoutProps {
    rows?: number;
    value?: string;
    onChange?: React.ChangeEventHandler<HTMLTextAreaElement>;
    onKeyDown?: React.KeyboardEventHandler<HTMLTextAreaElement>;
    onFocus?: React.FocusEventHandler<HTMLTextAreaElement>;
    onBlur?: React.FocusEventHandler<HTMLTextAreaElement>;
    disabled?: boolean;
    id?: string;
    innerRef?: React.RefObject<HTMLTextAreaElement> | React.RefCallback<HTMLTextAreaElement>;
    ariaLabel?: string;
    ariaDescribedBy?: string;
    dataRole?: string;
}
declare const TextArea: ({ rows, value, onChange, onKeyDown, onFocus, onBlur, disabled, id, innerRef, ariaLabel, ariaDescribedBy, dataRole, p, padding, pt, paddingTop, pr, paddingRight, pb, paddingBottom, pl, paddingLeft, px, paddingX, py, paddingY, ...rest }: TextAreaProps) => React.JSX.Element;
export default TextArea;
