import React from "react";
import { TextAreaProps } from "./TextArea";
import { AutocompleteSuggestion } from "../../types/AutocompleteSuggestion";
export type OnTextAreaChange = (text: string) => void;
export type SuggestionsPosition = "above" | "below";
export interface SuggestionTextAreaProps extends Omit<TextAreaProps, "onChange"> {
    suggestions: AutocompleteSuggestion[];
    onTextChange: OnTextAreaChange;
    onTextEnter: (value: string) => void;
    onTextAreaFocus: () => void;
    enableSuggestions: boolean;
    suggestionsPosition: SuggestionsPosition;
    maxVisibleSuggestions?: number;
}
declare const SuggestionTextArea: ({ suggestions, value, onTextChange, onTextEnter, onTextAreaFocus, onKeyDown, enableSuggestions, suggestionsPosition, maxVisibleSuggestions, ...rest }: SuggestionTextAreaProps) => React.JSX.Element;
export default SuggestionTextArea;
