import React from "react";
import { SpaceProps } from "styled-system";
type SelectSize = "s" | "m" | "l";
export interface SelectionOption {
    value: string;
    label: string;
}
export interface SelectProps extends SpaceProps {
    value: string | undefined;
    setValue: (value: string | undefined) => void;
    options: Array<SelectionOption>;
    placeholder?: string;
    size?: SelectSize;
    disabled?: boolean;
    id?: string;
    ariaLabel?: string;
    ariaDescribedBy?: string;
    dataRole?: string;
    borderColor?: string;
    borderWidth?: string;
}
declare const Select: ({ options, value, setValue, size, disabled, id, ariaLabel, ariaDescribedBy, dataRole, placeholder, borderColor, borderWidth, ...spaceProps }: SelectProps) => React.JSX.Element;
export default Select;
