import { SpaceProps } from "styled-system";
import React from "react";
import { SageIconType } from "../../types/SageIconType";
export interface SageIconBaseProps {
    fill?: string;
    size?: number;
    role?: string;
}
interface StyledSvgProps extends SpaceProps {
    /** Rotation of icon in degrees */
    rotation?: number;
    /** Fill color when hovering over icon */
    hoverFill?: string;
    /** Fill color when icon active */
    activeFill?: string;
    /** Fill color when parent button is hovered */
    hoverButtonParentFill?: string;
    /** Fill color when parent button is active */
    activeButtonParentFill?: string;
    /** Fill color when parent button is disabled */
    disabledButtonParentFill?: string;
    stroke?: string;
    strokeWidth?: string;
    alt?: string;
    viewBox?: string;
}
export interface StyledSageIconProps extends SageIconBaseProps, StyledSvgProps {
    icon: SageIconType;
}
export declare const StyledSvg: import("styled-components").StyledComponent<React.ForwardRefExoticComponent<Omit<{
    [x: string]: /*elided*/ any;
    theme: import("styled-components").DefaultTheme;
    as: string | React.ComponentClass<any, any> | React.FunctionComponent<any>;
    forwardedAs: string | React.ComponentClass<any, any> | React.FunctionComponent<any>;
}, "ref"> & React.RefAttributes<HTMLElement>>, import("styled-components").DefaultTheme, StyledSvgProps, never>;
declare const StyledSageIcon: ({ fill, size, viewBox, role, icon, rotation, hoverFill, ...rest }: StyledSageIconProps) => React.JSX.Element;
export default StyledSageIcon;
