import React from "react";
import { FlattenSimpleInterpolation } from "styled-components";
import { SpaceProps } from "styled-system";
import { CssColor } from "../../types/CssColor";
export type HeadingAs = "h1" | "h2" | "h3" | "h4";
interface HnProps extends SpaceProps {
    color?: CssColor;
    lineHeight?: string;
    fontSize?: string;
    customCss?: FlattenSimpleInterpolation;
}
export interface HeadingProps extends HnProps {
    as: HeadingAs;
    tabIndex?: number;
    innerRef?: React.RefObject<HTMLHeadingElement>;
    children: React.ReactNode;
}
declare const Heading: ({ as, innerRef, children, ...rest }: HeadingProps) => React.JSX.Element;
export default Heading;
