import { Component, ReactNode } from "react";
import { SessionMessage } from "../../types/SessionMessage";
import { SessionIdType } from "../../types/Session";
interface ErrorBoundaryProps {
    children?: ReactNode;
    onError: ReactNode;
}
interface State {
    hasError: boolean;
}
declare class ErrorBoundary<T extends ErrorBoundaryProps = ErrorBoundaryProps> extends Component<T, State> {
    constructor(props: T);
    static getDerivedStateFromError(): {
        hasError: boolean;
    };
    render(): (T["children"] & null) | (T["children"] & {}) | T["onError"] | undefined;
}
interface ChatBubbleErrorBoundaryProps extends ErrorBoundaryProps {
    message: SessionMessage;
    sessionId: SessionIdType;
}
export declare class ChatBubbleErrorBoundary extends ErrorBoundary<ChatBubbleErrorBoundaryProps> {
    componentDidCatch(_error: Error, _errorInfo: React.ErrorInfo): void;
}
export default ErrorBoundary;
