import { SpaceProps } from "styled-system";
import { SageIconType } from "../../types/SageIconType";
import React from "react";
export interface SageIconButtonProps extends SpaceProps {
    /** The icon to display */
    icon: SageIconType;
    /** Size in pixels */
    size?: number;
    /** Rotation of icon in degrees */
    rotation?: number;
    /** Handler for button click */
    onClick?: (e: React.MouseEvent<HTMLButtonElement>) => void;
    ariaLabel?: string;
    ariaDescribedBy?: string;
    ariaPressed?: boolean;
    ariaExpanded?: boolean;
    disabled?: boolean;
    innerRef?: React.RefObject<HTMLButtonElement>;
    fill?: string;
}
declare const SageIconButton: ({ icon, size, rotation, onClick, ariaLabel, ariaDescribedBy, ariaPressed, ariaExpanded, disabled, innerRef, fill, ...rest }: SageIconButtonProps) => React.JSX.Element;
export default SageIconButton;
