import React from "react";
import { MessageIdType } from "../../types/SessionMessage";
import { ButtonSize, ButtonStyle } from "./AiKitButton.styles";
import { SageIconType } from "../../types/SageIconType";
export type PromptButtonStyle = "chip" | ButtonStyle;
export type PromptButtonWrap = "wrap" | "ellipsis";
export declare const EllipsisSpan: import("styled-components").StyledComponent<"span", import("styled-components").DefaultTheme, {}, never>;
export interface PromptButtonProps {
    buttonStyle: PromptButtonStyle;
    dataRole?: string;
    prompt: string;
    label?: string;
    messageId: MessageIdType | undefined;
    messagePartId: MessageIdType | undefined;
    buttonSize: ButtonSize;
    buttonWrap: PromptButtonWrap;
    disabled?: boolean;
    additionalContext?: Record<string, any>;
    icon?: SageIconType;
    iconFill?: string;
    iconSize?: number;
    canonicalQuestionId?: string;
}
declare const PromptButton: ({ buttonStyle, dataRole, prompt, label, messageId, messagePartId, buttonSize, buttonWrap, disabled, additionalContext, icon, iconFill, iconSize, canonicalQuestionId, }: PromptButtonProps) => React.JSX.Element;
export default PromptButton;
